<?php
namespace lib\field;

class Text extends \lib\Field
{
	public $type;
	private $password;
	
	public function __construct($name, $password=false, $validation=array(), $value='')
	{
		$this->type = $password?'password':'text';
		
		$this->name = $name;
		$this->value = get_magic_quotes_gpc()?stripslashes($value):$value;
		$this->password = $password;
		
		if(!isset($validation['optional']))
		{
			$this->validation = array_merge(array('optional'=>false), $validation);
		} else
		{
			$this->validation = $validation;
		}
	}
	
	public function input($placeholder=false, $autocomplete=true, $maxlength=false)
	{
		return '<input class="text" type="'.$this->type.'" name="'.$this->name.'['.$this->form->bulk.']" value="'.$this->value.'"'.($placeholder?' placeholder="'.$this->label().'"':'').((!$autocomplete || $this->form->preset == 'administrate')?' autocomplete="off"':'').(($maxlength && isset($this->validation['max_length']))?' maxlength="'.$this->validation['max_length'].'"':'').'/>';
	}
}